/* FILE: mutils.h                               (D. Tottingham  03/24/91)

This is an include file of defines, data structure definitions and
external declarations that are common in the mutils module.

*/

#ifndef _MUTILS_
#define _MUTILS_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define INVALID_DRIVE           -1


/************************************************************************
                        STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        unsigned int days;
        unsigned int hours;
        unsigned int minutes;
        unsigned int seconds;
        unsigned int millisec;
} U_ELAPSED_TIME;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC long u_build_date (double);
PUBLIC int u_build_date_fn (double, char *, char *);
PUBLIC char * u_build_timeline (double, unsigned int);
PUBLIC double u_convert_time (struct timeb);
PUBLIC long u_get_diskspace (char *, int *);
PUBLIC void u_gmtime (double, U_ELAPSED_TIME *);
PUBLIC FLAG u_ispow2 (unsigned long);
PUBLIC double u_log2 (unsigned long);
PUBLIC int u_strncmp (char far *, char *, unsigned int);
PUBLIC char far * u_strcpy (char far *, char far *);
PUBLIC char far * u_strncpy (char far *, char far *, unsigned int);
PUBLIC unsigned int u_strnlen (char far *, unsigned int);
PUBLIC double u_timestamp ();
PUBLIC void u_tzset_GMT ();

#endif
